# API-Mockups – Überblick (Version 1.0)

Dieses Dokument beschreibt beispielhafte Schnittstellen (Mockups), die Hochschulen verwenden können, um:

- einen Mock-Server aufzusetzen,
- Clients zu entwickeln,
- Prototypen für Oberflächen zu testen,
- Workflows zu simulieren.

Die Mockups orientieren sich an einer REST-Architektur; andere Paradigmen (GraphQL, gRPC) sind möglich.

## 1. Basiskonzepte

- **Base URL (Mock):** `https://mock-bda.local/api/v1`
- Alle Endpunkte sind als **Beispiel** zu verstehen.
- Authentifizierung ist im Hochschulpaket optional und kann projektbezogen ergänzt werden.

## 2. Beispiel-Endpunkte

### 2.1 Cases

- `GET /cases` – Liste aller Fälle (Filter optional).
- `POST /cases` – Anlage eines neuen Falls.
- `GET /cases/{case_id}` – Details zu einem Fall.
- `PATCH /cases/{case_id}` – Aktualisierung ausgewählter Felder.
- `DELETE /cases/{case_id}` – Löschen/Archivieren (je nach Implementierung).

### 2.2 Modules

- `GET /modules` – Liste registrierter Module.
- `POST /modules` – Registrierung eines neuen Moduls.
- `GET /modules/{module_id}` – Details zu einem Modul.

### 2.3 Evidence

- `GET /cases/{case_id}/evidence` – Liste aller Befunde zu einem Fall.
- `POST /cases/{case_id}/evidence` – Hinzufügen eines Befundes.
- `GET /evidence/{evidence_id}` – Detailansicht eines Befundes.

### 2.4 Assessments

- `POST /cases/{case_id}/assessments` – Anstoßen einer Bewertung (via Modul).
- `GET /cases/{case_id}/assessments` – Liste aller Bewertungen.
- `GET /assessments/{assessment_id}` – Details zu einer Bewertung.

### 2.5 Export (Mock)

- `POST /cases/{case_id}/export` – Auslösung eines Exportvorgangs (z. B. Gutachtenentwurf).
- Rückgabe: URL oder Blob-ID eines erzeugten Dokuments (nur als Mock im Hochschulpaket).

## 3. OpenAPI-Mock

Die Datei `openapi_bda_hochschule_mock_v1.yaml` in diesem Ordner beschreibt eine mögliche OpenAPI-Spezifikation auf Basis der hier dargestellten Endpunkte.

Hochschulen können:

- aus dieser Datei Client-SDKs generieren,
- Mock-Server erzeugen,
- Endpunkte nach eigenen Anforderungen erweitern oder einschränken.

## 4. Freiheitsgrad für Hochschulprojekte

- Die hier genannten Endpunkte sind **nicht verbindlich**, sondern ein arbeitsfähiger Vorschlag.
- Projekte können z. B. zusätzliche Endpunkte für:
  - Benutzerverwaltung,
  - Modulversionierung,
  - Audit-Logs
  ergänzen.
