# Functional Specification – BDA Hochschulpaket (Version 1.0)

## 1. Zielbild

Der Building Diagnostics Assistant (BDA) ist ein modular aufgebautes, KI‑unterstütztes Expertensystem zur strukturierten Gebäude- und Schadensdiagnostik. 
Das hier bereitgestellte Hochschulpaket beschreibt **nur** die offenen, nicht-proprietären Anteile:

- fachneutrale Diagnoselogik (vom Befund zur Bewertung),
- modulare Architektur auf Ebene der Schnittstellen,
- generische Datenmodelle für Fälle, Module und Befunde,
- Mockups für spätere API-Endpunkte.

Der IP‑Kern (Prompt-Architektur, interne Kernel-Logik, Audit-Framework, proprietäre Module) ist **nicht** Bestandteil dieses Pakets.

## 2. Systemkontext

Beteiligte Akteure (Rollenmodell):

- **Sachverständige / Gutachter**: nutzen BDA zur strukturierten Befunderhebung, Bewertung und Gutachtenerstellung.
- **Hochschulen / Forschungsteams**: entwickeln, testen und validieren Teilmodule, Oberflächen und Algorithmen auf Basis der bereitgestellten Modelle.
- **Mandanten / Gerichte / Versicherungen**: erhalten aus BDA erzeugte, nachvollziehbare Gutachten (nicht Bestandteil dieses Pakets).
- **Systembetreiber**: verantworten Betrieb, Audit-Trails, Compliance (außerhalb dieses Pakets).

## 3. Funktionsumfang (Scope Hochschulpaket)

### 3.1 Im Scope

- Darstellung einer fachneutralen, modularen BDA-Architektur.
- Beschreibung eines **Case-Modells** (Diagnosefall).
- Beschreibung eines **Module-Modells** (fachliches Modul, z. B. Thermografie, Feuchte, Metallbau – abstrakt).
- Beschreibung eines **Evidence-/Befund-Modells**.
- Beschreibung eines **Assessment-/Bewertungsmodells**.
- Mockup-Definition für:
  - Fallanlage (Create Case),
  - Befundaufnahme,
  - Bewertungsaufrufe,
  - Export-Trigger.

### 3.2 Out of Scope

- Implementierung einer lauffähigen BDA-Plattform.
- IP‑kritische Details der Prompt-Architektur.
- konkrete, fachbezogene Diagnoseregeln (werden nur exemplarisch, abstrahiert gezeigt).
- proprietäre Audit-Mechanismen (Hashing, Integritätsnachweise).

## 4. Kernfunktionen (fachneutral)

1. **Case Management**
   - Anlage, Aktualisierung und Archivierung von Diagnosedfällen.
   - Zuordnung von Modulen zum jeweiligen Fall.
   - Statusführung (z. B. „Befunderhebung“, „Bewertung“, „Gutachtenerstellung“).

2. **Module Handling**
   - Registrierung von Modulen (z. B. Thermografie-Modul, Metallbau-Modul).
   - Definition von Moduleingängen (Parameter) und -ausgängen (Bewertung, Empfehlungen).
   - Versionierung von Modulen.

3. **Evidence Management**
   - Erfassung von Messwerten, Bildern, Laborbefunden, Plänen und Notizen.
   - strukturierte Metadaten (Zeit, Ort, Messkontext).

4. **Assessment**
   - Ableitung von Bewertungen aus Befunden (diagnostische Logik).
   - Dokumentation von Begründungen.
   - Verknüpfung zur Gutachtenerstellung (außerhalb dieses Pakets als Mockup vorgesehen).

## 5. Qualitäts- und Compliance-Anforderungen (abgeleitet, hochschulgeeignet)

- **Nachvollziehbarkeit**: Jede Bewertung muss auf klar referenzierte Befunde zurückführbar sein.
- **Versionierbarkeit**: Module und Datenmodelle müssen versioniert vorliegen.
- **Modularität**: Fachlogik ist in klar umrissenen Modulen gekapselt.
- **Erweiterbarkeit**: Neue Module (z. B. Metallbau, Holzbau) lassen sich über definierte Schnittstellen integrieren.
- **Datenschutz**: Hochschulprojekte arbeiten vorzugsweise mit anonymisierten oder synthetischen Daten.

## 6. Use Cases (aus Hochschulsicht)

1. **Use Case 1 – Entwicklung eines UI-Prototyps**
   - Ziel: grafische Oberfläche zur Anlage und Bearbeitung von Fällen.
   - Input: Case-Schema, Module-Schema.
   - Output: Funktionsfähiger UI-Prototyp (z. B. Web-App).

2. **Use Case 2 – Implementierung eines Beispielmoduls**
   - Ziel: Fachmodul (z. B. „Einfaches Feuchtemodul“) auf Basis des Module-Schemas implementieren.
   - Input: Module-Schema, Beispiel-JSON.
   - Output: Backend/Funktionsblock, der auf Eingabeparameter reagiert und Bewertungen simuliert.

3. **Use Case 3 – Simulation von Diagnoselogiken**
   - Ziel: Entscheidungslogiken anhand von Befunddaten testen.
   - Input: Evidence-/Assessment-Modelle, Beispiel-Cases.
   - Output: Auswertung von Szenarien, Sensitivitätsanalysen.

4. **Use Case 4 – API-Design und Mocking**
   - Ziel: vollständiges API-Design auf Basis der Mockup-Schnittstellen entwickeln.
   - Input: OpenAPI-Mockup, API-Übersicht.
   - Output: lauffähiger Mock-Server, Dokumentation, ggf. Client-Bibliotheken.

## 7. Technische Rahmenbedingungen

Die Datenmodelle werden in diesem Paket in folgenden Formaten bereitgestellt:

- **JSON-Schema / Beispiel-JSON** für Cases, Module, Befunde, Bewertungen.
- **YAML/OpenAPI** für API-Mockups.
- **Markdown** für Spezifikationen und Erläuterungen.

Die konkrete Technologie (Programmiersprache, Frameworks, Datenbank) ist nicht vorgegeben und kann von der Hochschule frei gewählt werden.
